/*
---------------------------------------------------------
   #  #  #    #===    ###    ##    #
  #    ##     #===   #      #  #    #
   #   #      #===    ###    ##    #
---------------------------------------------------------
WARZZZ 2.4

Plugin made by <VeCo>

Special thanks to:
 - carbonated : for the idea for the 'Previous Selected Weapon'.
option in the weapon menu.
 - Exolent : For some help with percentage calculation for
captured ring stats.
 - Numb - For his colorchat.inc.
 - VEN - For his is_player_stuck stock.
       - (ConnorMcLeod) For blinking dot on the radar code.
---------------------------------------------------------
If you modify the code, please DO NOT change the author!
---------------------------------------------------------
Contacts:
e-mail: veco.kn@gmail.com
skype: veco_kn
---------------------------------------------------------
Changes log:
 -> v 1.0 = First release!
 -> v 1.1 = Added 'Previous Selected Weapon' option in the
weapon menu.
 -> v 1.2 = Now, the 'Previous Selected Weapon' option don't shows
	    the weapon menu again after selecting the previous weapon.
	    Added /guns command.
	    Fixed small bugs.
	    Added CVAR wz_item_invsuit_max_inv.
 -> v 2.0 = Fully rewritten code!
	    Optimized code.
	    Added/Fixed lots of CVARs and other stuff.
	    Added ML support.
 -> v 2.1 = Fixed bug with capturing the last ring.
	    Fixed bug with adding new ring spawn points.
 -> v 2.2 = Removed hardcoded configs dir.
	    Optimized respawn code.
	    On adding new ring spawn point, team name will
	    be displayed instead of team number in the info
	    message.
	    Added wz_spawn_item admin command to make spawn
	    points for custom items, that will be respawned
	    on every round.
	    Increased lenght of ML string messages to maximum
	    (191 characters).
	    Fixed bug with checking neutral items as enemy
	    items.
 -> v 2.3 = Fixed bug with weapon remembering and
	    weapon/class menus.
	    Fixed de_nuke ring spawn points coordinates.
 -> v 2.4 = Now explosion effect is sent in MSG_PVS datagram
	    instead of MSG_BROADCAST.
	    Optimized "env_hud" think code.
	    Added /medic and /ammo commands to notify players
	    that you need help.
	    Fixed position of "Remember Weapon" option in
	    weapon menus.
	    Optimized colorchat system.
---------------------------------------------------------
Don't forget to visit http://www.amxmodxbg.org :)
---------------------------------------------------------
*/

#include <amxmodx>
#include <amxmisc>
#include <hamsandwich>
#include <fakemeta>
#include <fakemeta_util>
#include <cstrike>

#define SPAWN_RING_ACCESS ADMIN_RCON // admin access level for wz_spawn_ring command (see amxconst.inc)
#define SPAWN_ITEM_ACCESS ADMIN_RCON // admin access level for wz_spawn_item command

/*START - From colorchat.inc by Numb */
enum Color {
	NORMAL = 1,
	GREEN,
	TEAM_COLOR,
	GREY,
	RED,
	BLUE,
}

new TeamName[][] = {
	"",
	"TERRORIST",
	"CT",
	"SPECTATOR"
}
/*END - From colorchat.inc by Numb */

// Objective entities - everything you add here will be removed on spawn
new const g_sz_const_objective_names[][] =
{
	"info_bomb_target",
	"func_bomb_target",
	"info_hostage_rescue",
	"func_hostage_rescue",
	"hostage_entity",
	"info_vip_start",
	"func_vip_safetyzone",
	"func_escapezone",
	"player_weaponstrip",
	"game_player_equip"
}

// Team names
new const g_sz_const_team_names[][] =
{
	"Neutral",
	"Red",
	"Blue"
}

// Team colors (RRR,GGG,BBB)
new const g_i_const_team_colors[][3] =
{
	{255,255,255}, // Neutral -> white
	{255,000,000}, // Red
	{000,000,255} // Blue
}

// Teams
enum
{
	TEAM_NEUTRAL = 0,
	TEAM_RED,
	TEAM_BLUE,
	MAX_TEAMS
}

// Weapon data type (which valu to get from g_package_const_weapon_data?)
enum
{
	WEAPON_NAME = 0,
	WEAPON_AMMO,
	WEAPON_ID
}

// Weapon names, clip ammo and CSW_* id
new const g_package_const_weapon_data[][][] =
{
	{"",0,0},
	{"weapon_glock18",20,CSW_GLOCK18},
	{"weapon_usp",12,CSW_USP},
	{"weapon_p228",13,CSW_P228},
	{"weapon_deagle",7,CSW_DEAGLE},
	{"weapon_fiveseven",20,CSW_FIVESEVEN},
	{"weapon_elite",30,CSW_ELITE},
	{"weapon_galil",35,CSW_GALIL},
	{"weapon_m4a1",30,CSW_M4A1},
	{"weapon_mp5navy",30,CSW_MP5NAVY},
	{"weapon_famas",25,CSW_FAMAS},
	{"weapon_ak47",30,CSW_AK47},
	{"weapon_sg552",30,CSW_SG552},
	{"weapon_aug",30,CSW_AUG},
	{"weapon_tmp",30,CSW_TMP},
	{"weapon_ump45",25,CSW_UMP45},
	{"weapon_mac10",30,CSW_MAC10},
	{"weapon_p90",50,CSW_P90},
	{"weapon_scout",10,CSW_SCOUT},
	{"weapon_m3",8,CSW_M3},
	{"weapon_xm1014",7,CSW_XM1014},
	{"weapon_sg550",30,CSW_SG550},
	{"weapon_g3sg1",20,CSW_GLOCK18},
	{"weapon_awp",10,CSW_AWP},
	{"weapon_m249",100,CSW_M249}
}

// Dynamic array rings and custom items spawn points data
enum _:ARRAY_WZ_ENT_SPAWNS
{
	Float:WZ_ENT_COORDS[3],
	WZ_ENT_TEAM,
	WZ_ENT_TYPE // always 0 for rings
}

// Team data values
enum
{
	TEAM_DATA_RINGS = 0,
	TEAM_DATA_MONEY,
	MAX_TEAM_DATA
}

// Lang keys (ML) for classes' names
new const g_sz_const_class_langkeys[][] =
{
	"",
	"MENU_CLASS_ASSAULT",
	"MENU_CLASS_SNIPER",
	"MENU_CLASS_ENGINEER",
	"MENU_CLASS_MEDIC"
}

// Classes
enum
{
	CLASS_NONE = 0,
	CLASS_ASSAULT,
	CLASS_SNIPER,
	CLASS_ENGINEER,
	CLASS_MEDIC,
	MAX_CLASSES
}

// Item models
new const g_sz_const_item_models[][] =
{
	"",
	"models/w_chainammo.mdl",
	"models/w_kevlar.mdl",
	"models/warzzz/mine.mdl",
	"models/w_medkit.mdl"
}

// Items
enum
{
	ITEM_AMMOBOX = 1,
	ITEM_INVSUIT,
	ITEM_MINE,
	ITEM_MEDKIT,
	MAX_ITEMS
}

// Item data values
enum
{
	ITEM_DATA_COST = 0,
	ITEM_DATA_MAX,
	MAX_ITEM_DATA
}

// "Must change" values
enum
{
	CHANGE_CLASS = 0,
	CHANGE_PRIMARY,
	CHANGE_SECONDARY,
	MAX_CHANGE
}

// Weapon menu remember data values 
enum
{
	REM_WEAPON_PRIMARY = 0,
	REM_WEAPON_SECONDARY,
	REM_WEAPON_PAGE_PRIMARY, // secondary weapons are only 6, don't need pages
	MAX_REMEMBER
}

// Variables...
new g_sz_ringfile[66],g_i_total_rings,g_i_total_items, Array:g_array_ringspawns,Array:g_array_itemspawns, g_synchud_main,g_synchud_money,g_synchud_misc, g_envhud_ent, g_msgid_sendaudio, g_eff_spr_explosion,
g_cvar_min_players, g_cvar_class_change_mode, g_cvar_msg_capture, g_cvar_block_weapons_drop, g_cvar_res_time,g_cvar_res_protection_time,
g_cvar_money_reset_new_round,g_cvar_money_ring_capture,g_cvar_money_ring_lose, g_cvar_weapons_enable[sizeof g_package_const_weapon_data],g_cvar_weapons_bpammo_multi,
g_cvar_money_normal_kill,g_cvar_money_hs_kill,g_cvar_money_knife_kill,g_cvar_money_knife_hs_kill,
g_cvar_item_cmd_hide,g_cvar_item_use_self,g_cvar_item_public,g_cvar_item_one_round,g_cvar_item_disconnect_mode, g_cvar_item_remove,g_cvar_item_remove_cost_multi, g_cvar_item_data[MAX_ITEM_DATA][MAX_ITEMS],
g_cvar_item_ammobox_give, g_cvar_item_invsuit_give,g_cvar_item_invsuit_max_inv,
g_cvar_item_mine_give,g_cvar_item_mine_damage,g_cvar_item_mine_radius,
g_i_team_data[MAX_TEAM_DATA][MAX_TEAMS], g_i_item_num[MAX_ITEMS],
g_i_user_class[33],g_i_user_remembered_weapon[33][MAX_REMEMBER], g_i_user_respawn_time[33], bool:g_b_user_must_change[33][MAX_CHANGE],
g_fwd_spawn_objectives
public plugin_precache()
{
	// Ring model
	precache_model("models/warzzz/ring.mdl")
	
	// Item models
	new i
	for(i=1;i<sizeof g_sz_const_item_models;i++) precache_model(g_sz_const_item_models[i])
	
	// Sounds
	precache_sound("items/suitchargeok1.wav") // ring capture
	
	precache_sound("common/bodydrop2.wav") // item drop
	precache_sound("items/gunpickup2.wav") // item pickup
	precache_sound("weapons/electro4.wav") // item remove
	
	precache_sound("items/smallmedkit1.wav") // medkit item sound
	
	g_eff_spr_explosion = precache_model("sprites/zerogxplode.spr") // mine item explosion sprite
	
	// Create the dynamic array where we will store all the rings' spawn points data (coords, team)
	g_array_ringspawns = ArrayCreate(ARRAY_WZ_ENT_SPAWNS)
	// Create the dynamic array where we will store all the custom items' spawn points data (coords, team, type)
	g_array_itemspawns = ArrayCreate(ARRAY_WZ_ENT_SPAWNS) // just not to mess up with the rings
	
	// Register FM_Spawn forward to remove objective entities
	g_fwd_spawn_objectives = register_forward(FM_Spawn,"Fm_Spawn_Objectives")
	
	// Block the use of buy menu
	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString,"info_map_parameters"))
	fm_set_kvd(ent,"buying","3") // "Neither CT's nor T's can buy guns"
	dllfunc(DLLFunc_Spawn,ent) // spawn the entity to take effect!
}

public plugin_init() {
	// Plugin registration - DO NOT EDIT!
	register_plugin("WARZZZ", "2.4", "<VeCo>")
	
	// ML translations file
	register_dictionary("warzzz.txt")
	
	// Tracking CVAR
	register_cvar("wz_version","2.4",FCVAR_SERVER | FCVAR_SPONLY)
	
	// HudSync objects for HUD messages
	g_synchud_main = CreateHudSyncObj()
	g_synchud_money = CreateHudSyncObj()
	g_synchud_misc = CreateHudSyncObj()
	
	// Get user message ids...
	g_msgid_sendaudio = get_user_msgid("SendAudio")
	
	// CVARs...
	g_cvar_min_players = register_cvar("wz_min_players","2")
	
	g_cvar_class_change_mode = register_cvar("wz_class_change_mode","0")
	
	g_cvar_msg_capture = register_cvar("wz_message_capture","1")
	
	g_cvar_block_weapons_drop = register_cvar("wz_block_weapons_drop","1")
	
	g_cvar_res_time = register_cvar("wz_respawn_time","3")
	g_cvar_res_protection_time = register_cvar("wz_respawn_protection_time","2.0")
	
	g_cvar_money_reset_new_round = register_cvar("wz_money_reset_new_round","0")
	g_cvar_money_ring_capture = register_cvar("wz_money_ring_capture","200")
	g_cvar_money_ring_lose = register_cvar("wz_money_ring_lose","200")
	
	g_cvar_money_normal_kill = register_cvar("wz_money_normal_kill","100")
	g_cvar_money_hs_kill = register_cvar("wz_money_headshot_kill","200")
	g_cvar_money_knife_kill = register_cvar("wz_money_knife_kill","300")
	g_cvar_money_knife_hs_kill = register_cvar("wz_money_knife_headshot_kill","400")
	
	// Loop trough all weapons...
	new i, sz_weapon_cvar_str[19]
	for(i=1;i<sizeof g_package_const_weapon_data;i++)
	{
		// Get weapons' names and add "wz_" in front of them
		formatex(sz_weapon_cvar_str,charsmax(sz_weapon_cvar_str),"wz_%s",g_package_const_weapon_data[i][WEAPON_NAME])
		
		// Register each weapon's CVAR (for enable/disable)
		g_cvar_weapons_enable[i] = register_cvar(sz_weapon_cvar_str,"1")
	}
	
	g_cvar_weapons_bpammo_multi = register_cvar("wz_weapons_bpammo_multi","2.0")
	
	g_cvar_item_cmd_hide = register_cvar("wz_item_command_hide","0")
	g_cvar_item_use_self = register_cvar("wz_item_use_self","1")
	g_cvar_item_public = register_cvar("wz_item_public","0")
	g_cvar_item_one_round = register_cvar("wz_item_one_round","0")
	g_cvar_item_disconnect_mode = register_cvar("wz_item_disconnect_mode","2")
	
	g_cvar_item_remove = register_cvar("wz_item_remove","1")
	g_cvar_item_remove_cost_multi = register_cvar("wz_item_remove_cost_multi","1.5")
	
	g_cvar_item_data[ITEM_DATA_COST][ITEM_AMMOBOX] = register_cvar("wz_item_ammobox_cost","500")
	g_cvar_item_data[ITEM_DATA_MAX][ITEM_AMMOBOX] = register_cvar("wz_item_ammobox_max","25")
	g_cvar_item_ammobox_give = register_cvar("wz_item_ammobox_give","30")
	
	g_cvar_item_data[ITEM_DATA_COST][ITEM_INVSUIT] = register_cvar("wz_item_invsuit_cost","350")
	g_cvar_item_data[ITEM_DATA_MAX][ITEM_INVSUIT] = register_cvar("wz_item_invsuit_max","15")
	g_cvar_item_invsuit_give = register_cvar("wz_item_invsuit_give","51")
	g_cvar_item_invsuit_max_inv = register_cvar("wz_item_invsuit_max_inv","0")
	
	g_cvar_item_data[ITEM_DATA_COST][ITEM_MINE] = register_cvar("wz_item_mine_cost","750")
	g_cvar_item_data[ITEM_DATA_MAX][ITEM_MINE] = register_cvar("wz_item_mine_max","20")
	g_cvar_item_mine_give = register_cvar("wz_item_mine_give","1000")
	g_cvar_item_mine_damage = register_cvar("wz_item_mine_damage","350")
	g_cvar_item_mine_radius = register_cvar("wz_item_mine_radius","80")
	
	g_cvar_item_data[ITEM_DATA_COST][ITEM_MEDKIT] = register_cvar("wz_item_medkit_cost","250")
	g_cvar_item_data[ITEM_DATA_MAX][ITEM_MEDKIT] = register_cvar("wz_item_medkit_max","25")
	
	// Admin command for spawning rings at player's current position
	register_clcmd("wz_spawn_ring","Cmd_AdminSpawnRing",SPAWN_RING_ACCESS,"[team]")
	register_clcmd("wz_spawn_item","Cmd_AdminSpawnItem",SPAWN_ITEM_ACCESS,"<type> [team]")
	
	// Item drop commands
	register_clcmd("say /item","Cmd_PlayerItemDrop",.info = "- drops an item depending on your class")
	register_clcmd("say_team /item","Cmd_PlayerItemDrop",.info = "- drops an item depending on your class")
	register_clcmd("say /items","Cmd_PlayerItemDrop",.info = "- drops an item depending on your class")
	register_clcmd("say_team /items","Cmd_PlayerItemDrop",.info = "- drops an item depending on your class")
	
	// Change class commands
	register_clcmd("say /class","Cmd_PlayerChangeClass",.info = "- reopens class menu")
	register_clcmd("say_team /class","Cmd_PlayerChangeClass",.info = "- reopens class menu")
	register_clcmd("say /change","Cmd_PlayerChangeClass",.info = "- reopens class menu")
	register_clcmd("say_team /change","Cmd_PlayerChangeClass",.info = "- reopens class menu")
	register_clcmd("say /changeclass","Cmd_PlayerChangeClass",.info = "- reopens class menu")
	register_clcmd("say_team /changeclass","Cmd_PlayerChangeClass",.info = "- reopens class menu")
	
	// Change guns commands
	register_clcmd("say /guns","Cmd_PlayerChangeWeapons",.info = "- reopens weapons menu")
	register_clcmd("say_team /guns","Cmd_PlayerChangeWeapons",.info = "- reopens weapons menu")
	register_clcmd("say /weapons","Cmd_PlayerChangeWeapons",.info = "- reopens weapons menu")
	register_clcmd("say_team /weapons","Cmd_PlayerChangeWeapons",.info = "- reopens weapons menu")
	
	register_clcmd("say /medic","Cmd_PlayerCallMedic",.info = "- notifies all medics to help you")
	register_clcmd("say_team /medic","Cmd_PlayerCallMedic",.info = "- notifies all medics to help you")
	register_clcmd("say /ammo","Cmd_PlayerCallAssault",.info = "- notifies all assaults to help you")
	register_clcmd("say_team /ammo","Cmd_PlayerCallAssault",.info = "- notifies all assaults to help you")
	
	// Player chooses team, class...
	register_clcmd("chooseteam","Cmd_PlayerJoinTeam")
	register_clcmd("jointeam","Cmd_PlayerJoinTeam")
	register_clcmd("joinclass","Cmd_PlayerJoinClass")
	
	// Weapon drop command (should we block it?)
	register_clcmd("drop","Cmd_PlayerWeaponDrop")
	
	// Player spawns...
	RegisterHam(Ham_Spawn,"player","Ham_PlayerSpawn",1)
	
	// Used for WZ entities - ring, items; env_hud
	RegisterHam(Ham_Touch,"info_target","Ham_EntityTouch")
	RegisterHam(Ham_Think,"info_target","Ham_EntityThink")
	
	// Dropped weapon spawns...
	RegisterHam(Ham_Spawn,"weaponbox","Ham_WeaponBoxSpawn")
	
	// Somebody dies...
	register_event("DeathMsg","Event_DeathMsg","a")
	
	// Hook round start/end
	register_logevent("Logevent_Round_Start",2,"1=Round_Start")
	register_logevent("Logevent_Round_End",2,"1=Round_End")
	
	// Get current map's name and format the ring spawns file name and path
	new sz_cfgdir[32],sz_mapname[32]
	get_configsdir(sz_cfgdir,charsmax(sz_cfgdir))
	get_mapname(sz_mapname,charsmax(sz_mapname))
	formatex(g_sz_ringfile,charsmax(g_sz_ringfile),"%s/warzzz/%s.ini",sz_cfgdir,sz_mapname)
	
	// Load all WZ entities for this map... (rings, custom items)
	WZ_Ent_LoadAll()
	
	// All objective entities have been removed - we don't need this forward anymore...
	unregister_forward(FM_Spawn,g_fwd_spawn_objectives)
	
	// Create static thinking entity (env_hud) - used for displaying continuous HUD messages to the players
	g_envhud_ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString,"info_target"))
	set_pev(g_envhud_ent,pev_classname,"env_hud") // env? i like the standart entity prefixes :3
	set_pev(g_envhud_ent,pev_nextthink,get_gametime() + 1.0) // set next think time to CURRENT_TIME + 1 second
}

// Plugin have been disabled (map change?) - destroy the WZ entities spawns arrays to free memory
public plugin_end()
{
	ArrayDestroy(g_array_ringspawns)
	ArrayDestroy(g_array_itemspawns)
}

// CVARs have been created, try to load custom values from the configuration file
public plugin_cfg()
{
	// Format the configuration fil path
	new sz_cfgdir[32],sz_cfgfile[44]
	get_configsdir(sz_cfgdir,charsmax(sz_cfgdir))
	
	formatex(sz_cfgfile,charsmax(sz_cfgfile),"%s/warzzz.cfg",sz_cfgdir)
	
	// Ring spawn points file exists?
	if(file_exists(sz_cfgfile))
	{
		// Yes - exec the configuration file and load custom CVAR values
		server_cmd("exec ^"%s^"",sz_cfgfile)
	} else {
		// Else - Oops, something went wrong, file doesn't exist...
		log_amx("%L",LANG_SERVER,"SV_NOTIFY_NOCFG",sz_cfgfile)
	}
}

// Player tries to spawn a ring...
public Cmd_AdminSpawnRing(id,level,cid)
{
	// Not admin - don't continue
	// Isn't alive - don't get spectator's coordinates...
	if(!cmd_access(id,level,cid,1) || !is_user_alive(id)) return PLUGIN_HANDLED
	
	// Get admin's origin
	static Float:v_f_origin[3]
	pev(id,pev_origin,v_f_origin)
	
	// Little fix :3
	v_f_origin[2] += 20.0
	
	// Get team arg (if specified)
	static sz_arg_team[2], i_arg_team
	read_argv(1,sz_arg_team,charsmax(sz_arg_team))
	
	// Keep the [team] arg's value in proper bounds (there's no other team...)
	i_arg_team = clamp(str_to_num(sz_arg_team),TEAM_NEUTRAL,TEAM_BLUE) // 0 <= [team] <= 2
	
	// Save player's coordinates into the ring spawn points file...
	WZ_Ent_SaveSpawn(id, v_f_origin,i_arg_team, 0) // no type = ring
	
	// Don't show "Unknown command"...
	return PLUGIN_HANDLED
}

// Player tries to spawn a custom item...
public Cmd_AdminSpawnItem(id,level,cid)
{
	// Not admin (no specified <type>) - don't continue
	// Isn't alive - don't get spectator's coordinates...
	if(!cmd_access(id,level,cid,2) || !is_user_alive(id)) return PLUGIN_HANDLED
	
	// Get admin's origin
	static Float:v_f_origin[3]
	pev(id,pev_origin,v_f_origin)
	
	// Little fix :3
	v_f_origin[2] += 20.0
	
	// Get team arg (if specified)
	static sz_arg_type[2],sz_arg_team[2], i_arg_type,i_arg_team
	read_argv(1,sz_arg_type,charsmax(sz_arg_type))
	read_argv(2,sz_arg_team,charsmax(sz_arg_team))
	
	// Keep the <type> arg's value in proper bounds (there's no other type...)
	i_arg_type = clamp(str_to_num(sz_arg_type),CLASS_ASSAULT,CLASS_MEDIC) // ammobox <= <type> <= medkit
	// Keep the [team] arg's value in proper bounds (there's no other team...)
	i_arg_team = clamp(str_to_num(sz_arg_team),TEAM_NEUTRAL,TEAM_BLUE) // 0 <= [team] <= 2
	
	// Save player's coordinates into the ring spawn points file...
	WZ_Ent_SaveSpawn(id, v_f_origin,i_arg_team, i_arg_type)
	
	// Don't show "Unknown command"...
	return PLUGIN_HANDLED
}

// Player tries to drop an item...
public Cmd_PlayerItemDrop(id)
{
	// Don't have a class - he mustn't drop an item
	if(g_i_user_class[id] == CLASS_NONE)
	{
		PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L", id,"MSG_NOCLASS")
		
		return PLUGIN_CONTINUE
	}
	
	// Isn't alive - he shouldn't drop items...
	if(!is_user_alive(id))
	{
		PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L", id,"MSG_NOTALIVE")
		
		return PLUGIN_CONTINUE
	}
	
	// Get some values...
	static _:i_team,i_class, i_cvar_cost
	i_team = _:cs_get_user_team(id) // team (without CsTeams tag -> I hate tags :3)
	i_class = g_i_user_class[id] // class
	
	i_cvar_cost = get_pcvar_num(g_cvar_item_data[ITEM_DATA_COST][i_class]) // item cost CVAR
	
	// Don't have the needed amount of money - sorry, team
	if(g_i_team_data[TEAM_DATA_MONEY][i_team] < i_cvar_cost)
	{
		PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L (%L^x04 %i^x01)", id,"MSG_NOMONEY", id,"MSG_INFO_NEED", i_cvar_cost)
		
		return PLUGIN_CONTINUE
	}
	
	// Get some values...
	static i_cvar_max
	
	i_cvar_max = get_pcvar_num(g_cvar_item_data[ITEM_DATA_MAX][i_class]) // item max CVAR (because too many entities isn't good :3)
	
	// CVAR is enabled? (there is max value for this item?)
	if(i_cvar_max)
	{
		// Max value reached - don't drop more items...
		if(i_cvar_max == g_i_item_num[i_class])
		{
			PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L (%L^x04 %i^x01)", id,"MSG_MAXITEMREACHED", id,"MSG_INFO_MAX", i_cvar_max)
			
			return PLUGIN_CONTINUE
		}
		
		// Else - increase the value of this type of items
		g_i_item_num[i_class]++
	}
	
	// Success, woohoo, we must drop the item now!
	
	// Distract the item cost from player's team money
	g_i_team_data[TEAM_DATA_MONEY][i_team] -= i_cvar_cost
	
	// Play sound...
	emit_sound(id, CHAN_AUTO, "common/bodydrop2.wav", VOL_NORM,ATTN_NORM, 0, PITCH_NORM)
	
	// Drop the item!
	Player_ItemDrop(id,i_team,i_class, -1) // this is not a custom item!
	
	// Should we block the display of the command in the chat? (CVAR)
	return get_pcvar_num(g_cvar_item_cmd_hide) ? PLUGIN_HANDLED_MAIN : PLUGIN_CONTINUE
	
	// *
	// lol, writing some random comments in the code is fun... :3
}

// Drop the item!
Player_ItemDrop(id,i_team,i_class, array_item)
{
	// Create item's entity (info_target?)
	static ent
	ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString,"info_target"))
	
	// Success...
	if(ent)
	{
		// Store item's origin here... (also other data if this is a custom item)
		static package_array[ARRAY_WZ_ENT_SPAWNS]
		
		// This item is not custom item?
		if(array_item == -1)
		{
			// Make some vars for item's origin calculation
			static Float:v_f_origin[3], Float:v_f_velocity[3]
			
			// Get the coordinates of the player that dropped the item
			pev(id,pev_origin,v_f_origin)
			
			// Add some velocity from his eyes
			velocity_by_aim(id,64,v_f_velocity)
			
			// Add the velocity vector to the origin [ Player (eyes) --> Item ]
			v_f_origin[0] += v_f_velocity[0]
			v_f_origin[1] += v_f_velocity[1]
			
			package_array[WZ_ENT_COORDS] = _:v_f_origin
		} else {
			// Else - This item is a custom item!
			
			ArrayGetArray(g_array_itemspawns,array_item,package_array) // unpack array's data for this custom item
			
			i_team = package_array[WZ_ENT_TEAM] // store custom item's team in a more convenient variable
			i_class = package_array[WZ_ENT_TYPE] // store custom item's type in a more convenient variable
			
			set_wz_ent_custom_item(ent) // set this item as a custom item!
		}
		
		// Set classname and model (item?)
		set_pev(ent,pev_classname,"item_warzzz")
		engfunc(EngFunc_SetModel,ent,g_sz_const_item_models[i_class])
		
		// Set entity solidity (don't want to step on it like on a stone) and movetype (make it fall)
		set_pev(ent,pev_solid,SOLID_TRIGGER)
		set_pev(ent,pev_movetype,MOVETYPE_TOSS)
		
		// Set entity solid box size for collision checking
		engfunc(EngFunc_SetSize, ent, Float:{-1.0,-1.0,0.0},Float:{1.0,1.0,1.0})
		
		// Set EARTH gravity
		set_pev(ent,pev_gravity,1.0)
		
		// Set WZ entity values
		set_wz_ent_team(ent,!get_pcvar_num(g_cvar_item_public) ? i_team : TEAM_NEUTRAL) // team - public items CVAR is ON? Make it neutral then.
		set_wz_ent_type(ent,i_class) // item type (type is the same as the class)
		set_wz_ent_owner(ent,i_team != TEAM_NEUTRAL ? id : 0) // item owner - if it's neutral, there shouldn't be an owner
		
		// Set item origin
		engfunc(EngFunc_SetOrigin,ent, package_array[WZ_ENT_COORDS])
	}
}

// Player calls all teammate medics to help him!
public Cmd_PlayerCallMedic(id) Player_CallHelp(id,CLASS_MEDIC,"MSG_CALLNOTIFY_MEDIC")
// Player calls all teammate assaults to help him!
public Cmd_PlayerCallAssault(id) Player_CallHelp(id,CLASS_ASSAULT,"MSG_CALLNOTIFY_ASSAULT")

// Player is calling for help...
Player_CallHelp(id,i_class,const sz_lang_key[])
{
	// Isn't alive - he shouldn't call for help...
	if(!is_user_alive(id))
	{
		PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L", id,"MSG_NOTALIVE")
		
		return
	}
	
	PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L",id,sz_lang_key)
	
	// Get caller's name...
	static sz_name[32]
	get_user_name(id,sz_name,charsmax(sz_name))
	
	// Get some values...
	static i_players[32],i_num, i,ii
	get_players(i_players,i_num,"ae",TeamName[_:cs_get_user_team(id)]) // get all alive teammate players and their number
	
	// Loop trough all teammate players in the server...
	for(i=0;i<i_num;i++)
	{
		ii = i_players[i]
		
		// Receiver isn't the needed class or receiver is the sender - continue with the next player...
		if(g_i_user_class[ii] != i_class || ii == id) continue
		
		// Notify receiver about caller's position on the radar
		// "Look at the radar, find him and help him!"
		message_begin(MSG_ONE_UNRELIABLE,g_msgid_sendaudio,.player = ii)
		write_byte(id)
		write_string("%")
		write_short(100)
		message_end()
		
		// Notify caller about receiver's position on the radar
		// "Look at the radar, find him to help you faster!"
		message_begin(MSG_ONE_UNRELIABLE,g_msgid_sendaudio,.player = id)
		write_byte(ii)
		write_string("%")
		write_short(100)
		message_end()
		
		// Notify receiver about caller
		PrepareColorChat(ii,GREEN,"^x04[WARZZZ]^x03 %s^x01 %L",sz_name,id,"MSG_CALLNOTIFY_RECEIVE")
	}
}

// Player tries to change his class with a command...
public Cmd_PlayerChangeClass(id)
{
	// Should be able to change his class? (depending on change class mode CVAR)
	if(get_pcvar_num(g_cvar_class_change_mode) != 2)
	{
		PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L",id,"MSG_CLASS_CANTCHANGE")
		
		return
	}
	
	// Yes, he should...
	
	// Set "Must change" to his class (checked on spawn -> true? -> show class menu)
	g_b_user_must_change[id][CHANGE_CLASS] = true
	
	PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L",id,"MSG_CLASS_CHANGENEXT")
}

// Player tries to change his weapons with a command...
public Cmd_PlayerChangeWeapons(id)
{
	// Set "Must change" to his weapons - primary & secondary (checked on spawn -> true? -> show weapons menu)
	
	g_b_user_must_change[id][CHANGE_PRIMARY] = true
	g_b_user_must_change[id][CHANGE_SECONDARY] = true
	
	PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L",id,"MSG_WEAPONS_CHANGENEXT")
}

// Player tries to change his team...
public Cmd_PlayerJoinTeam(id)
{
	// Get team arg (if specified)
	static sz_arg[2], i_arg
	read_argv(1,sz_arg,charsmax(sz_arg))
	
	// Convert it to number (we don't need strings)
	i_arg = str_to_num(sz_arg)
	
	// Did he really changed his team? (to a valied one?)
	if(i_arg < TEAM_RED || i_arg > MAX_TEAMS) return
	
	// Success - now, update all his items' team to keep the game balanced
	
	// Loop trough all WZ item entities...
	static ent
	ent = -1
	
	while((ent = engfunc(EngFunc_FindEntityByString, ent,"classname","item_warzzz")) != 0)
	{
		// Isn't owner of this item? OK, continue with the others...
		if(get_wz_ent_owner(ent) != id) continue
		
		// Set the new team
		set_wz_ent_team(ent,i_arg)
	}
}

// Player tries to change his class...
public Cmd_PlayerJoinClass(id)
{
	// Player changes his class - he must respawn (comes in server? changes his class during game?)
	
	Player_PrepareRespawn(id)
}

// Player tries to drop his weapon...
public Cmd_PlayerWeaponDrop(id) return get_pcvar_num(g_cvar_block_weapons_drop) ? PLUGIN_HANDLED : PLUGIN_CONTINUE // Should we block weapons drop? (CVAR)

// Player spawns!
public Ham_PlayerSpawn(id)
{
	// Not alive - don't continue
	if(!is_user_alive(id)) return
	
	// Remove all his weapons
	fm_strip_user_weapons(id)
	fm_give_item(id,"weapon_knife") // give him only knife
	
	// Don't have class? Must change his class? Class is changed every round? (CVAR)
	if(g_i_user_class[id] == CLASS_NONE || g_b_user_must_change[id][CHANGE_CLASS] || get_pcvar_num(g_cvar_class_change_mode) == 1)
	{
		// OK, show the class menu...
		Player_MenuChangeClass(id)
	} else {
		// Else - show weapons menu
		
		static i_remembered_weapon
		
		// Is the primary weapon remembered?
		i_remembered_weapon = g_i_user_remembered_weapon[id][REM_WEAPON_PRIMARY]
		// Mustn't change his weapon? Is remembered?
		if(!g_b_user_must_change[id][REM_WEAPON_PRIMARY] && i_remembered_weapon)
		{
			// Weapon is remembered - give it automatic...
			fm_give_item(id,g_package_const_weapon_data[i_remembered_weapon][WEAPON_NAME])
			cs_set_user_bpammo(id,g_package_const_weapon_data[i_remembered_weapon][WEAPON_ID][0],floatround(g_package_const_weapon_data[i_remembered_weapon][WEAPON_AMMO][0] * get_pcvar_float(g_cvar_weapons_bpammo_multi)))
		}
		
		// Is the secondary weapon remembered?
		i_remembered_weapon = g_i_user_remembered_weapon[id][REM_WEAPON_SECONDARY]
		// Mustn't change his weapon? Is remembered?
		if(!g_b_user_must_change[id][REM_WEAPON_SECONDARY] && i_remembered_weapon)
		{
			// Weapon is remembered - give it automatic...
			fm_give_item(id,g_package_const_weapon_data[i_remembered_weapon][WEAPON_NAME])
			cs_set_user_bpammo(id,g_package_const_weapon_data[i_remembered_weapon][WEAPON_ID][0],floatround(g_package_const_weapon_data[i_remembered_weapon][WEAPON_AMMO][0] * get_pcvar_float(g_cvar_weapons_bpammo_multi)))
		}
		
		// Player must change his primary weapon?
		if(g_b_user_must_change[id][CHANGE_PRIMARY])
		{
			// Yes, show the primary weapon menu...
			Player_MenuPrimaryWeapon(id)
		} else if(g_b_user_must_change[id][CHANGE_SECONDARY])
		{
			// Else - Player must change his secondary weapon?
			
			// Yes, show the secondary weapon menu...
			Player_MenuSecondaryWeapon(id)
		}
	}
	
	// Get some values...
	static Float:f_cvar_time
	f_cvar_time = get_pcvar_float(g_cvar_res_protection_time) // spawn protection time
	
	// Is spawn protection enabled?
	if(f_cvar_time)
	{
		// Get some values...
		
		static _:i_team
		i_team = _:cs_get_user_team(id) // team (without CsTeams tag -> I hate tags :3)
		
		// Set godmode and nice team color glow
		fm_set_user_godmode(id,1)
		fm_set_rendering(id, kRenderFxGlowShell, g_i_const_team_colors[i_team][0],g_i_const_team_colors[i_team][1],g_i_const_team_colors[i_team][2], kRenderNormal, 50)
		
		// Remove existing respawn protection task
		remove_task(id)
		// Remove the spawn protection after X seconds (CVAR)
		set_task(f_cvar_time,"Player_RemoveSpawnProtection",id)
	} else {
		// Spawn protection is not enabled - set rendering + alpha (for invsuit item)
		fm_set_rendering(id, kRenderFxNone, 0,0,0, kRenderTransAlpha, 255)
	}
}

// Player is trying to spawn on a ring...
public Player_SpawnOnRing(id)
{
	// Get some values...
	static _:i_team
	i_team = _:cs_get_user_team(id) // team (without CsTeams tag -> I hate tags :3)
	
	// Player's team hasn't captured any rings - don't continue
	if(!g_i_team_data[TEAM_DATA_RINGS][i_team]) return
	
	// Get some values...
	static i_random_ring
	
	// Strange, eh? :3
	_StartPoint_SelectRandomRing:
	{
		// Set random ring index (for the dynamic array)
		i_random_ring = random(g_i_total_rings)
		
		// Loop trough all WZ ring entities...
		static ent
		ent = -1
		
		while((ent = engfunc(EngFunc_FindEntityByString, ent,"classname","info_ring")) != 0)
		{
			// If this is the ring we are searching for (index = i_random_ring)...
			if(get_wz_ent_id(ent) == i_random_ring)
			{
				// If the team is not the team of the player,,.
				if(get_wz_ent_team(ent) != i_team)
				{
					// Go to the start point and do this again with another random index...
					goto _StartPoint_SelectRandomRing;
					
					// *
					// This is the first time I use goto and it seems to be the only one case
					// where I add ";" in the end of the line.
					// I like it! :3
				} else {
					// Else - this ring is a valid choice, stop the loop and continue with the code below...
					
					break
				}
			}
		}
	}
	
	// Get some values...
	static package_array[ARRAY_WZ_ENT_SPAWNS]
	
	ArrayGetArray(g_array_ringspawns,i_random_ring,package_array) // unpack array's data for this ring
	
	// Set player origin (at the ring position, received from the dynamic array)
	engfunc(EngFunc_SetOrigin,id, package_array[WZ_ENT_COORDS])
	
	// If the ring is used, respawn to default spawn points on the map!
	if(is_player_stuck(id)) ExecuteHamB(Ham_CS_RoundRespawn,id)
}

// Must remove spawn protection (time's up)
public Player_RemoveSpawnProtection(id)
{
	// Player not connected - don't continue...
	if(!is_user_connected(id)) return
	
	// Remove godmode and set rendering + alpha (for invsuit item)
	fm_set_user_godmode(id)
	fm_set_rendering(id, kRenderFxNone, 0,0,0, kRenderTransAlpha, 255)
	
	client_print(id,print_center,"%L", id,"PL_NOTIFY_RESPROTECTEND")
}

// Menu - change class
Player_MenuChangeClass(id)
{
	static menu
	
	static sz_cache_lang_msg[128]
	formatex(sz_cache_lang_msg,127,"%L",id,"MENU_CLASS")
	
	// Create menu with title (ML) and handler
	menu = menu_create(sz_cache_lang_msg,"MenuChangeClass_Handler")
	
	// Loop trough all classes
	static i, sz_i_str[2]
	for(i=1;i<MAX_CLASSES;i++)
	{
		// Convert integer "i" to string "sz_i_str"
		num_to_str(i,sz_i_str,charsmax(sz_i_str))
		
		// Format option string (mark the current class with grey color "\d")
		formatex(sz_cache_lang_msg,charsmax(sz_cache_lang_msg),"%s%L",(g_i_user_class[id] == i) ? "\d" : "\w", id,g_sz_const_class_langkeys[i])
		menu_additem(menu,sz_cache_lang_msg, sz_i_str) // Add the option to the menu (info = class number)
	}
	
	// Display the menu
	menu_display(id,menu)
}

public MenuChangeClass_Handler(id,menu,item)
{
	// "Exit" option pressed or player isn't alive?
	if(item == MENU_EXIT || !is_user_alive(id))
	{
		// Close the menu and clear some memory...
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	// Make some vars...
	static i_access,i_callback, sz_info[2],i_get_info
	menu_item_getinfo(menu,item, i_access, sz_info,charsmax(sz_info), .callback = i_callback) // get menu option data (don't need "name")
	
	// Convert string "sz_info" to integer "i_get_info"
	i_get_info = str_to_num(sz_info)
	
	// Change the player's class to the selected one
	g_i_user_class[id] = i_get_info
	g_b_user_must_change[id][CHANGE_CLASS] = false // player has changed his class - mission complete!
	
	PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L^x04 %L^x01 %L.", id,"MSG_SELECTED", id,g_sz_const_class_langkeys[i_get_info], id,"MSG_INFO_CLASS")
	
	// Player must change his primary weapon?
	if(g_b_user_must_change[id][CHANGE_PRIMARY])
	{
		// Yes, show the primary weapon menu...
		Player_MenuPrimaryWeapon(id)
	} else if(g_b_user_must_change[id][CHANGE_SECONDARY])
	{
		// Else - check if player must change his secondary weapon?
		
		// Yes, show the secondary weapon menu...
		Player_MenuSecondaryWeapon(id)
	}
	
	// Close the menu and clear some memory...
	menu_destroy(menu)
	return PLUGIN_HANDLED
}

// Menu - primary weapons
Player_MenuPrimaryWeapon(id)
{
	static menu
	
	static sz_cache_lang_msg[128]
	formatex(sz_cache_lang_msg,127,"%L",id,"MENU_WEAPON_PRIMARY")
	
	// Create menu with title (ML) and handler
	menu = menu_create(sz_cache_lang_msg,"MenuPrimaryWeapon_Handler")
	
	// Loop trough all *primary* weapons (uses weapon data const)
	static i,ii, sz_i_str[3]
	
	// Reset the value of enabled weapons...
	ii = 1
	
	for(i=7;i<sizeof g_package_const_weapon_data;i++)
	{
		// Weapon is not enabled - continue with the next one...
		if(!get_pcvar_num(g_cvar_weapons_enable[i])) continue
		
		// Convert integer "i" to string "sz_i_str"
		num_to_str(i,sz_i_str,charsmax(sz_i_str))
		
		// Format option string (remove "_weapon" and make it ALL CAPS)
		formatex(sz_cache_lang_msg,charsmax(sz_cache_lang_msg),"%s",g_package_const_weapon_data[i][WEAPON_NAME])
		replace(sz_cache_lang_msg,charsmax(sz_cache_lang_msg),"weapon_","")
		strtoupper(sz_cache_lang_msg)
		
		menu_additem(menu,sz_cache_lang_msg, sz_i_str) // Add the option to the menu (info = weapon number)
		
		// If it's in the end of the page - add "Weapon remember" option to the menu
		if(!(ii % 6)) Menu_AddRememberOption(id,menu,CHANGE_PRIMARY, sz_cache_lang_msg)
		
		// Increase the value of enabled weapons...
		ii++
	}
	
	if(ii % 6) Menu_AddRememberOption(id,menu,CHANGE_PRIMARY, sz_cache_lang_msg)
	
	// Display the menu (on last used page)
	menu_display(id,menu, g_i_user_remembered_weapon[id][REM_WEAPON_PAGE_PRIMARY])
}

public MenuPrimaryWeapon_Handler(id,menu,item)
{
	// "Exit" option pressed or player isn't alive?
	if(item == MENU_EXIT || !is_user_alive(id))
	{
		// Something happened (unexpected?), set "Must change" to primary weapon
		g_b_user_must_change[id][CHANGE_PRIMARY] = true
		
		// Close the menu and clear some memory...
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	// Make some vars...
	static i_access,i_callback, sz_info[3],sz_name[12], i_get_info
	menu_item_getinfo(menu,item, i_access, sz_info,charsmax(sz_info), sz_name,charsmax(sz_name), i_callback) // get menu option data
	
	// Convert string "sz_info" to integer "i_get_info"
	i_get_info = str_to_num(sz_info)
	
	// Player pressed "Weapon remember" option? (reserved id -> -1)
	if(i_get_info == -1)
	{
		// Invert the "Must change" primary weapon bool var so that we will know if the menu should be shown
		g_b_user_must_change[id][CHANGE_PRIMARY] = !g_b_user_must_change[id][CHANGE_PRIMARY]
		
		// Show the menu again...
		Player_MenuPrimaryWeapon(id)
		
		// Close the menu and clear some memory...
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	// Give the selected weapon...
	fm_give_item(id,g_package_const_weapon_data[i_get_info][WEAPON_NAME])
	cs_set_user_bpammo(id,g_package_const_weapon_data[i_get_info][WEAPON_ID][0],floatround(g_package_const_weapon_data[i_get_info][WEAPON_AMMO][0] * get_pcvar_float(g_cvar_weapons_bpammo_multi)))
	
	// Remember last used weapon (used if it's not "Must change", i.e. the weapon is remembered)
	if(!g_b_user_must_change[id][CHANGE_PRIMARY]) g_i_user_remembered_weapon[id][REM_WEAPON_PRIMARY] = i_get_info
	
	// Set last used page (primary weapons start from 7 - that should be page 0, not 1)
	g_i_user_remembered_weapon[id][REM_WEAPON_PAGE_PRIMARY] = (i_get_info - 7) / 7
	
	// Must change secondary?
	if(g_b_user_must_change[id][CHANGE_SECONDARY]) Player_MenuSecondaryWeapon(id) // Yes, show the secondary weapon menu...
	
	// Close the menu and clear some memory...
	menu_destroy(menu)
	return PLUGIN_HANDLED
}

Player_MenuSecondaryWeapon(id)
{
	static menu
	
	static sz_cache_lang_msg[128]
	formatex(sz_cache_lang_msg,127,"%L",id,"MENU_WEAPON_SECONDARY")
	
	// Create menu with title (ML) and handler
	menu = menu_create(sz_cache_lang_msg,"MenuSecondaryWeapon_Handler")
	
	// Loop trough all *secondary* weapons (uses weapon data const)
	static i,ii, sz_i_str[3]
	for(i=1;i<7;i++)
	{
		// Weapon is not enabled - continue with the next one...
		if(!get_pcvar_num(g_cvar_weapons_enable[i])) continue
		
		// Convert integer "i" to string "sz_i_str"
		num_to_str(i,sz_i_str,charsmax(sz_i_str))
		
		// Format option string (remove "_weapon" and make it ALL CAPS)
		formatex(sz_cache_lang_msg,charsmax(sz_cache_lang_msg),"%s",g_package_const_weapon_data[i][WEAPON_NAME])
		replace(sz_cache_lang_msg,charsmax(sz_cache_lang_msg),"weapon_","")
		strtoupper(sz_cache_lang_msg)
		
		menu_additem(menu,sz_cache_lang_msg, sz_i_str)  // Add the option to the menu (info = weapon number)
		
		// Increase the value of enabled weapons...
		ii++
	}
	
	// If there are enabled weapons - add "Weapon remember" option to the menu
	if(ii) Menu_AddRememberOption(id,menu,CHANGE_SECONDARY, sz_cache_lang_msg)
	
	// Reset the value of enabled weapons for the next loop...
	ii = 0
	
	// Disable menu paginating to prevent second page
	menu_setprop(menu,MPROP_PERPAGE,0)
	
	// Display the menu (on last used page)
	menu_display(id,menu)
}

public MenuSecondaryWeapon_Handler(id,menu,item)
{
	// "Exit" option pressed or player isn't alive?
	if(item == MENU_EXIT || !is_user_alive(id))
	{
		// Something happened (unexpected?), set "Must change" to secondary weapon
		g_b_user_must_change[id][CHANGE_SECONDARY] = true
		
		// Close the menu and clear some memory...
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	// Make some vars...
	static i_access,i_callback, sz_info[3],sz_name[12], i_get_info
	menu_item_getinfo(menu,item, i_access, sz_info,charsmax(sz_info), sz_name,charsmax(sz_name), i_callback) // get menu option data
	
	// Convert string "sz_info" to integer "i_get_info"
	i_get_info = str_to_num(sz_info)
	
	// Player pressed "Weapon remember" option? (reserved id -> -1)
	if(i_get_info == -1)
	{
		// Invert the "Must change" primary weapon bool var so that we will know if the menu should be shown
		g_b_user_must_change[id][CHANGE_SECONDARY] = !g_b_user_must_change[id][CHANGE_SECONDARY]
		
		// Show the menu again...
		Player_MenuSecondaryWeapon(id)
		
		// Close the menu and clear some memory...
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}
	
	// Give the selected weapon...
	fm_give_item(id,g_package_const_weapon_data[i_get_info][WEAPON_NAME])
	cs_set_user_bpammo(id,g_package_const_weapon_data[i_get_info][WEAPON_ID][0],floatround(g_package_const_weapon_data[i_get_info][WEAPON_AMMO][0] * get_pcvar_float(g_cvar_weapons_bpammo_multi)))
	
	// Remember last used weapon (used if it's not "Must change", i.e. the weapon is remembered)
	if(!g_b_user_must_change[id][CHANGE_SECONDARY]) g_i_user_remembered_weapon[id][REM_WEAPON_SECONDARY] = i_get_info
	
	// Close the menu and clear some memory...
	menu_destroy(menu)
	return PLUGIN_HANDLED
}

Menu_AddRememberOption(id,menu,i_weapontype, sz_cache_lang_msg[128])
{
	// Format option string (add [YES] or [NO] if it's enabled)
	formatex(sz_cache_lang_msg,charsmax(sz_cache_lang_msg),"\y%L\w [%L\w]",\
	id, "MENU_WEAPON_REMEMBER",\
	id, g_b_user_must_change[id][i_weapontype] ? "MENU_NO" : "MENU_YES")
	
	menu_additem(menu,sz_cache_lang_msg, "-1") // Add the option to the menu (info = -1,reserved)
}

// Player tries to touch an info_target entity (WZ entity - ring, item?)
public Ham_EntityTouch(ent,id)
{
	// Not alive - don't continue
	if(!is_user_alive(id)) return HAM_IGNORED
	
	// Get entity's classname
	static sz_classname[32]
	pev(ent,pev_classname,sz_classname,charsmax(sz_classname))
	
	// Is the entity a ring?
	if(equal(sz_classname,"info_ring"))
	{
		// If the entity's team is the same as the player's we don't need to do anything
		if(_:cs_get_user_team(id) == get_wz_ent_team(ent)) return HAM_IGNORED
		
		// Not enough players to capture rings?
		if(get_playersnum() < get_pcvar_num(g_cvar_min_players))
		{
			client_print(id,print_center,"%L",id,"PL_NOTIFY_NOTENOUGH",get_pcvar_num(g_cvar_min_players))
			
			return HAM_IGNORED
		}
		
		// We are standing on an enemy/neutral ring, we can capture it!
		
		client_print(id,print_center,"%L",id,"PL_NOTIFY_CAPTURE")
		
		// USE key ("E"?) is pressed - capture this ring!
		if(pev(id,pev_button) & IN_USE) Player_RingCapture(ent,id)
		
		return HAM_IGNORED
	// Else - is the entity an item?
	} else if(equal(sz_classname,"item_warzzz"))
	{
		// Get some values...
		static i_ent_owner
		i_ent_owner = !get_pcvar_num(g_cvar_item_public) ? get_wz_ent_owner(ent) : 0 // If public items CVAR is set - make item's owner 0
		
		// Can't take items dropped by himself - don't continue (CVAR)
		if(!get_pcvar_num(g_cvar_item_use_self) && id == i_ent_owner) return HAM_IGNORED
		
		// Get some values...
		static _:i_team, i_ent_team_get,i_ent_team
		i_team = _:cs_get_user_team(id) // team (without CsTeams tag -> I hate tags :3)
		
		i_ent_team_get = get_wz_ent_team(ent)
		i_ent_team = (!get_pcvar_num(g_cvar_item_public)) ? i_ent_team_get : i_team // If public items CVAR is set - make item's team the same as the player's
		
		static i_type
		i_type = get_wz_ent_type(ent) // item type
		
		// Item is not a mine and it's the same team as player's or item is neutral (or it's a public item?)
		if(i_type != ITEM_MINE && (i_team == i_ent_team || !i_ent_team_get))
		{
			// Get the type of the item...
			switch(i_type)
			{
				// Item is ammobox...
				case ITEM_AMMOBOX:
				{
					// Get some values...
					static i_csw_weapon
					i_csw_weapon = get_user_weapon(id) // player's current weapon
					
					// Knifes and grenades don't have ammo!
					if(i_csw_weapon == CSW_KNIFE || i_csw_weapon == CSW_HEGRENADE || i_csw_weapon == CSW_FLASHBANG || i_csw_weapon == CSW_SMOKEGRENADE) return HAM_IGNORED
					
					// Set weapon's ammo...
					cs_set_user_bpammo(id,i_csw_weapon,cs_get_user_bpammo(id,i_csw_weapon) + get_pcvar_num(g_cvar_item_ammobox_give))
					
					// Play sound...
					emit_sound(id, CHAN_AUTO, "items/gunpickup2.wav", VOL_NORM,ATTN_NORM, 0 ,PITCH_NORM)
					
					// Item has been picked up - remove it from the floor
					engfunc(EngFunc_RemoveEntity,ent)
				}
				// Item is invisibility suit
				case ITEM_INVSUIT:
				{
					// Get some values...
					static i_renderamt, i_cvar_give,i_cvar_max
					
					i_renderamt = pev(id,pev_renderamt) // player's current alpha (render amount)
					i_cvar_give = get_pcvar_num(g_cvar_item_invsuit_give) // invisibility to give (CVAR)
					i_cvar_max = get_pcvar_num(g_cvar_item_invsuit_max_inv) // max allowed invisibility (CVAR)
					
					// Don't have the needed amount of money - sorry, team
					if((i_renderamt - i_cvar_give) < i_cvar_max)
					{
						client_print(id,print_center,"%L (%L %i)",id,"PL_NOTIFY_MAXINVREACHED", id,"MSG_INFO_MAX", i_cvar_max)
						
						return HAM_IGNORED
					}
					
					// Set the new invisibility
					set_pev(id,pev_renderamt,float(max(i_cvar_max,i_renderamt - i_cvar_give)))
					
					// Update the variables value with the new invisibility
					i_renderamt = pev(id,pev_renderamt)
					
					// Display a hud message showing current invisibility
					set_hudmessage(0, 255, 255, -1.0, 0.41, 0, 6.0, 1.0)
					ShowSyncHudMsg(id,g_synchud_misc, "+%i^n%L %i/255",i_cvar_give, id,"HUD_INVISIBILITY", i_renderamt)
					
					// Play sound...
					emit_sound(id, CHAN_AUTO, "items/gunpickup2.wav", VOL_NORM,ATTN_NORM, 0, PITCH_NORM)
					
					// Item has been picked up - remove it from the floor
					engfunc(EngFunc_RemoveEntity,ent)
				}
				case ITEM_MEDKIT:
				{
					// Don't need a medkit if player's on full health...
					if(pev(id,pev_health) >= 100.0) return HAM_IGNORED
					
					// Refill player's health to max (100?)
					set_pev(id,pev_health,100.0)
					
					// Play sound...
					emit_sound(id, CHAN_AUTO, "items/smallmedkit1.wav", VOL_NORM,ATTN_NORM, 0, PITCH_NORM)
					
					// Item has been picked up - remove it from the floor
					engfunc(EngFunc_RemoveEntity,ent)
				}
			}
			
			// CVAR is enabled? (there is max value for this item?)
			if(get_pcvar_num(g_cvar_item_data[ITEM_DATA_MAX][i_type])) g_i_item_num[i_type]-- // decrease the value of this type of item
			
			// Item has been picked up - don't continue below...
			return HAM_IGNORED
		}
		
		// Item is a mine and it's not the same team as player's or item is neutral (or it's a public item?)
		if(i_type == ITEM_MINE && (i_team != i_ent_team || !i_ent_team_get || get_pcvar_num(g_cvar_item_public)))
		{
			// Get player's origin
			static Float:v_f_origin[3]
			
			pev(ent,pev_origin,v_f_origin)
			
			static i_player
			i_player = -1
			
			// The owner of the entity is in the server?
			if(is_user_connected(i_ent_owner))
			{
				// Loop trough all players that are in the specified radius (CVAR)
				while((i_player = engfunc(EngFunc_FindEntityInSphere, i_player,v_f_origin,float(get_pcvar_num(g_cvar_item_mine_radius)))) != 0)
				{
					// Player is not alive (is player?) or is a teammate - don't continue
					if(!is_user_alive(i_player) || _:cs_get_user_team(i_player) == i_ent_team) continue
					
					// "i_player" takes damage from "i_ent_owner" by "ent" (bullet?)
					ExecuteHamB(Ham_TakeDamage, i_player, ent,i_ent_owner, float(get_pcvar_num(g_cvar_item_mine_damage)), DMG_BULLET)
				}
				
				// Mine has exploded - increase owner's team money (CVAR)
				g_i_team_data[TEAM_DATA_MONEY][i_ent_team] += get_pcvar_num(g_cvar_item_mine_give)
				
				PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L", id,"MSG_MINEDETONATED")
			} else {
				// Else - owner is not connected -> player still must die :S
				
				// Loop trough all players that are in the specified radius (CVAR)
				while((i_player = engfunc(EngFunc_FindEntityInSphere, i_player,v_f_origin,float(get_pcvar_num(g_cvar_item_mine_radius)))) != 0)
				{
					// Player is not alive (is player?)
					if(!is_user_alive(i_player)) continue
					
					// "i_player" takes damage from "ent" by "ent" (bullet?)
					ExecuteHamB(Ham_TakeDamage, i_player, ent,ent, float(get_pcvar_num(g_cvar_item_mine_damage)), DMG_BULLET)
				}
			}
			
			// Create explosion effect...
			engfunc(EngFunc_MessageBegin,MSG_PVS,SVC_TEMPENTITY,v_f_origin,0)
			write_byte(TE_EXPLOSION)
			engfunc(EngFunc_WriteCoord, v_f_origin[0])
			engfunc(EngFunc_WriteCoord, v_f_origin[1])
			engfunc(EngFunc_WriteCoord, v_f_origin[2] + 16.0) // little fix :3
			write_short(g_eff_spr_explosion) // explosion effect sprite
			write_byte(min(255,get_pcvar_num(g_cvar_item_mine_radius))) // prevent non-byte values
			write_byte(10) // play 1 second
			write_byte(0) // normal explosion
			message_end()
			
			// Item has been picked up - remove it from the floor (pick up?)
			engfunc(EngFunc_RemoveEntity,ent)
			
			// CVAR is enabled? (there is max value for this item?)
			if(get_pcvar_num(g_cvar_item_data[ITEM_DATA_MAX][ITEM_MINE])) g_i_item_num[ITEM_MINE]-- // decrease the value of this type of item
			
			// Mine has exploded - don't continue below...
			return HAM_IGNORED
		}
		
		// It's an enemy item...
		if(i_team != i_ent_team)
		{
			// Removing enemy items by players is enabled? (CVAR)
			if(get_pcvar_num(g_cvar_item_remove))
			{
				// Get some values...
				static i_remove_cost
				
				i_remove_cost = floatround(get_pcvar_num(g_cvar_item_data[ITEM_DATA_COST][i_type]) * get_pcvar_float(g_cvar_item_remove_cost_multi)) // cost for removing
				
				client_print(id,print_center,"%L (%L %i)",id,"PL_NOTIFY_REMOVE", id,"MSG_INFO_COST", i_remove_cost)
				
				// USE key ("E"?) is pressed - remove this item!
				if(pev(id,pev_button) & IN_USE)
				{
					// Don't have the needed amount of money - sorry, team
					if(g_i_team_data[TEAM_DATA_MONEY][i_team] < i_remove_cost)
					{
						PrepareColorChat(id,GREEN,"^x04[WARZZZ]^x01 %L (%L^x04 %i^x01)", id,"MSG_NOMONEY", id,"MSG_INFO_NEED", i_remove_cost)
						
						return HAM_IGNORED
					}
					
					// Distract the remove item cost from player's team money
					g_i_team_data[TEAM_DATA_MONEY][i_team] -= i_remove_cost
					
					// Play sound...
					emit_sound(ent, CHAN_AUTO, "weapons/electro4.wav", VOL_NORM,ATTN_NORM, 0, PITCH_NORM)
					
					// Item has been removed - remove it from the floor (you don't say...)
					engfunc(EngFunc_RemoveEntity,ent)
				}
			}
			
			// End...
			return HAM_IGNORED
		}
	}
	
	// End...
	return HAM_IGNORED
}

public Ham_EntityThink(ent)
{
	// If this entity isn't "env_hud" (static thinking WZ HUD displaying entity?) - don't continue...
	if(ent != g_envhud_ent) return HAM_IGNORED
	
	// Set next think time to CURRENT_TIME + 1 second
	set_pev(ent,pev_nextthink,get_gametime() + 1.0)
	
	// Server is empty - don't show any HUD messages...
	if(!get_playersnum()) return HAM_IGNORED
	
	// Get some values...
	static i_players[32],i_num, i,ii, iii
	get_players(i_players,i_num,"a") // get all alive players and their number
	
	static _:i_team, i_enemy_team // player's current team and player's enemy
	
	static sz_ring_stats_display[50] // ">>>>><<<<<" HUD string
	
	static i_captured_rings, i_captured_team_data[MAX_TEAMS], i_captured_color[3] // ...HUD color
	i_captured_rings = (g_i_team_data[TEAM_DATA_RINGS][TEAM_RED]+1 + g_i_team_data[TEAM_DATA_RINGS][TEAM_BLUE]+1) // total captured rings
	
	i_captured_team_data[TEAM_RED] = ((g_i_team_data[TEAM_DATA_RINGS][TEAM_RED]+1) * 40) / i_captured_rings // RED team's captured rings
	i_captured_team_data[TEAM_BLUE] = ((g_i_team_data[TEAM_DATA_RINGS][TEAM_BLUE]+1) * 40) / i_captured_rings // BLUE team's captured rings
	
	// Both team's captured rings are equal? (50:50)
	if(i_captured_team_data[TEAM_RED] == i_captured_team_data[TEAM_BLUE])
	{
		// Set white color...
		i_captured_color[0] = 255
		i_captured_color[1] = 255
		i_captured_color[2] = 255
	}
	
	// Loop trough all players in the server...
	for(i=0;i<i_num;i++)
	{
		// Store player index in a more convenient variable
		ii = i_players[i]
		
		// Get some values...
		i_team = _:cs_get_user_team(ii) // player's current team
		i_enemy_team = (i_team == TEAM_RED) ? TEAM_BLUE : TEAM_RED // player's enemy team
		
		// Display money HUD
		set_hudmessage(g_i_const_team_colors[i_team][0], g_i_const_team_colors[i_team][1], g_i_const_team_colors[i_team][2], 0.01, 0.18, .holdtime =  1.0)
		ShowSyncHudMsg(ii,g_synchud_money, "%L %i", ii,"HUD_MONEY", g_i_team_data[TEAM_DATA_MONEY][i_team])
		
		// Clear ring stats string from the last player
		formatex(sz_ring_stats_display,charsmax(sz_ring_stats_display),"")
		
		// Add ">><<" chars to the HUD...
		for(iii=0;iii<i_captured_team_data[i_team];iii++) add(sz_ring_stats_display,charsmax(sz_ring_stats_display),">") // player's current team stats
		for(iii=0;iii<i_captured_team_data[i_enemy_team];iii++) add(sz_ring_stats_display,charsmax(sz_ring_stats_display),"<") // player's enemy team stats
		
		// Player's team has captured more rings than the enemy team?
		if(i_captured_team_data[i_team] > i_captured_team_data[i_enemy_team])
		{
			// Set cyan color...
			i_captured_color[0] = 0
			i_captured_color[1] = 255
			i_captured_color[2] = 255
		} else if(i_captured_team_data[i_team] < i_captured_team_data[i_enemy_team])
		{
			// Else - enemy controls more rings?
			
			// Set red color...
			i_captured_color[0] = 255
			i_captured_color[1] = 0
			i_captured_color[2] = 0
		}
			
		// Display ring stats HUD...
		set_hudmessage(i_captured_color[0],i_captured_color[1],i_captured_color[2], -1.0, 0.0,  .holdtime =  1.0)
		ShowSyncHudMsg(ii,g_synchud_main, "[%i]^n[%i] %s %s %s [%i]", g_i_total_rings,\
		g_i_team_data[TEAM_DATA_RINGS][i_team],\
		g_sz_const_team_names[i_team],\
		sz_ring_stats_display,\
		g_sz_const_team_names[i_enemy_team],\
		g_i_team_data[TEAM_DATA_RINGS][i_enemy_team])
	}
	
	// End...
	return HAM_IGNORED
}

// WeaponBox entity tries to spawn? (weapon is dropped?)
public Ham_WeaponBoxSpawn(ent)
{
	// Should we remove dropped weapons? (CVAR)
	if(get_pcvar_num(g_cvar_block_weapons_drop))
	{
		// Yes - hide the dropped weapon...
		set_pev(ent,pev_effects,EF_NODRAW)
		
		// Don't spawn
		return HAM_SUPERCEDE
	}
	
	// Else - Do nothing...
	
	// End...
	return HAM_IGNORED
}

// DeathMsg is shown (player is killed?)
public Event_DeathMsg()
{
	// Get some values...
	static i_killer,i_victim
	
	i_killer = read_data(1) // killer id
	i_victim = read_data(2) // victim id
	
	// Victim has died - respawn him...
	
	Player_PrepareRespawn(i_victim)
	
	// Killer isn't in the server (killed by entity?) - don't continue
	if(!is_user_connected(i_killer)) return
	
	// Get some values...
	static _:i_team
	i_team = _:cs_get_user_team(i_killer) // killer's team
	
	// Killer and victim are teammates (mp_friendlyfire?) - don't continue...
	if(i_team == _:cs_get_user_team(i_victim)) return
	
	// Get some values...
	static bool:b_hs, sz_weapon[2]
	
	b_hs = bool:read_data(3) // is headshot kill?
	
	read_data(4,sz_weapon,charsmax(sz_weapon)) // weapon name
	// We need only it's first character, because we want only the weapon "knife" and there's no other weapon starting with "k"...
	
	// I have no idea what I'm doing...
	(g_i_team_data[TEAM_DATA_MONEY][i_team]) +=
	(
		(sz_weapon[0] != 'k') ? // is knife?
		(
			(b_hs) ? // is headshot?
			(
				get_pcvar_num(g_cvar_money_hs_kill)
			) : (
				get_pcvar_num(g_cvar_money_normal_kill)
			)
		) : (
			(b_hs) ? // is headshot?
			(
				get_pcvar_num(g_cvar_money_knife_hs_kill)
			) : (
				get_pcvar_num(g_cvar_money_knife_kill)
			)
		)
	)
}

// Player is about to respawn - remove existing respawn task and set up respawn time
Player_PrepareRespawn(id)
{
	// Remove existing respawn task to prevent some bugs...
	remove_task(id)
	
	// Get respawn time and set it to respawn time variable (from CVAR + little fix)
	g_i_user_respawn_time[id] = get_pcvar_num(g_cvar_res_time) + 1
	Player_CheckRespawn(id) // respawn the player
}

// Player tries to respawn...
public Player_CheckRespawn(id)
{
	// Not in the server, is alive (already has respawned?) or is spectator (or unassigned?) - don't continu
	if(!is_user_connected(id) || is_user_alive(id) || cs_get_user_team(id) == CS_TEAM_SPECTATOR || cs_get_user_team(id) == CS_TEAM_UNASSIGNED) return
	
	// Substract 1 from player's respawn time - is there still more time before respawn?
	if(--g_i_user_respawn_time[id])
	{
		// Yes, display HUD
		set_hudmessage(255, 170, 0, 0.57, 0.78, .holdtime = 1.0)
		ShowSyncHudMsg(id,g_synchud_misc, "%L", id,"HUD_RESPAWN", g_i_user_respawn_time[id])
		
		// Check again after 1 second...
		set_task(1.0,"Player_CheckRespawn",id)
	} else {
		// Else - no, respawn the player!
		ExecuteHamB(Ham_CS_RoundRespawn,id)
		
		// Check if the player must spawn on a ring...
		Player_SpawnOnRing(id)
	}
}

// Player captures a ring...
Player_RingCapture(ent,id)
{
	// Get some values...
	static _:i_team, i_enemy_team
	
	i_team = _:cs_get_user_team(id) // player's current team
	i_enemy_team = (i_team == TEAM_RED) ? TEAM_BLUE : TEAM_RED // player's enemy team
	
	// Get player's name
	static sz_name[32]
	get_user_name(id,sz_name,charsmax(sz_name))
	
	// Increase the number of captured rings by player's team and reward money (CVAR)
	g_i_team_data[TEAM_DATA_RINGS][i_team]++
	g_i_team_data[TEAM_DATA_MONEY][i_team] += get_pcvar_num(g_cvar_money_ring_capture)
	
	// Ring is not neutral?
	if(get_wz_ent_team(ent))
	{
		// Yes - decrease the number of captured rings by player's enemy team and substract money (CVAR)
		g_i_team_data[TEAM_DATA_RINGS][i_enemy_team]--
		g_i_team_data[TEAM_DATA_MONEY][i_enemy_team] = max(0,g_i_team_data[TEAM_DATA_MONEY][i_enemy_team] - get_pcvar_num(g_cvar_money_ring_lose)) // prevent negative money values
	}
	
	// Set ring's new team
	set_wz_ent_team(ent,i_team)
	
	// Play sound...
	emit_sound(ent, CHAN_AUTO, "items/suitchargeok1.wav", VOL_NORM,ATTN_NORM, 0, PITCH_NORM)
	
	// Get some values...
	static sz_lang_string[23]
	
	// Was this the last ring?
	formatex(sz_lang_string,charsmax(sz_lang_string),g_i_team_data[TEAM_DATA_RINGS][i_team] != g_i_total_rings ? "MSG_RING_CAPTURED" : "MSG_RING_CAPTURED_LAST")
	
	// Get player's team color
	static Color:i_color
	i_color = (i_team == _:CS_TEAM_T) ? RED : BLUE
	
	// Get some values...
	static i_players[32],i_num, i,ii
	
	// That was the last ring or message is enabled? (we must have a "win" message even if the messages are disabled!)
	if(strlen(sz_lang_string) > 17 || get_pcvar_num(g_cvar_msg_capture))
	{
		// Yes, get the number of players in the server
		get_players(i_players,i_num)
		
		// Loop trough all players in the server...
		for(i=0;i<i_num;i++)
		{
			// Store player index in a more convenient variable
			ii = i_players[i]
			
			// Format capture message... (last or not?)
			PrepareColorChat(ii,i_color,"^x04[WARZZZ]^x03 %s^x01 %L", sz_name, ii,sz_lang_string)
			
			// Player have captured the last ring?
			if(strlen(sz_lang_string) > 17)
			{
				// Format win message...
				PrepareColorChat(ii,i_color,"^x04[WARZZZ]^x03 %s^x01 %L", g_sz_const_team_names[i_team], ii,"MSG_WIN")
				
				// Kill the current player if it's an enemy of the player that have captured the last ring...
				if(cs_get_user_team(ii) == ((i_team == _:CS_TEAM_CT) ? CS_TEAM_T : CS_TEAM_CT)) ExecuteHamB(Ham_Killed, ii,id, 0) // Player "ii" killed by "id" (don't gib)
			}
		}
	}
}

// Round have started! (after freezetime)
public Logevent_Round_Start()
{
	// Remove all rings and custom items on the map...
	WZ_Ent_ClearAll()
	
	// Null team's captured rings number
	g_i_team_data[TEAM_DATA_RINGS][TEAM_RED] = 0
	g_i_team_data[TEAM_DATA_RINGS][TEAM_BLUE] = 0
	
	// Null team's money? (CVAR)
	if(get_pcvar_num(g_cvar_money_reset_new_round))
	{
		g_i_team_data[TEAM_DATA_MONEY][TEAM_RED] = 0
		g_i_team_data[TEAM_DATA_MONEY][TEAM_BLUE] = 0
	}
	
	// If there are ring spawns for this map..,
	if(g_i_total_rings)
	{
		static i
		for(i=0;i<g_i_total_rings;i++) Ring_Spawn(i) // Respawn all rings...
	}
	
	// If there are custom item spawns for this map..,
	if(g_i_total_items)
	{
		// Get some values...
		static package_array[ARRAY_WZ_ENT_SPAWNS], i_team,i_type
		
		static i
		for(i=0;i<g_i_total_items;i++)
		{
			ArrayGetArray(g_array_itemspawns,i,package_array) // unpack array's data for this custom item
			
			// Get custom item spawn team...
			i_team = package_array[WZ_ENT_TEAM]
			// Get custom item type...
			i_type = package_array[WZ_ENT_TYPE]
			
			Player_ItemDrop(0,i_team,i_type,i) // Respawn all custom items...
		}
	}
}

// Player has connected!
public client_connect(id)
{
	// Null all "user" variables from the last player with this id (null?)
	g_i_user_class[id] = CLASS_NONE
	
	g_i_user_remembered_weapon[id][REM_WEAPON_PRIMARY] = 0
	g_i_user_remembered_weapon[id][REM_WEAPON_SECONDARY] = 0
	g_i_user_remembered_weapon[id][REM_WEAPON_PAGE_PRIMARY] = 0
	
	g_b_user_must_change[id][CHANGE_CLASS] = true
	g_b_user_must_change[id][CHANGE_PRIMARY] = true
	g_b_user_must_change[id][CHANGE_SECONDARY] = true
}

// Player has disconnected!
public client_disconnect(id)
{
	// Null all "user" variables from the last player with this id (null?)
	g_i_user_class[id] = CLASS_NONE
	
	g_i_user_remembered_weapon[id][REM_WEAPON_PRIMARY] = 0
	g_i_user_remembered_weapon[id][REM_WEAPON_SECONDARY] = 0
	g_i_user_remembered_weapon[id][REM_WEAPON_PAGE_PRIMARY] = 0
	
	g_b_user_must_change[id][CHANGE_CLASS] = true
	g_b_user_must_change[id][CHANGE_PRIMARY] = true
	g_b_user_must_change[id][CHANGE_SECONDARY] = true
	
	// Get some values...
	static i_cvar_mode
	i_cvar_mode = get_pcvar_num(g_cvar_item_disconnect_mode) // what to do with player's items? (CVAR)
	
	// If we want to do something with player's items... (not leave it)
	if(i_cvar_mode > 0)
	{
		// Loop trough all item WZ entities...
		static ent
		ent = -1
		
		while((ent = engfunc(EngFunc_FindEntityByString, ent,"classname","item_warzzz")) != 0)
		{
			// Isn't owner of this item? OK, continue with the other...
			if(get_wz_ent_owner(ent) != id) continue
			
			// Item found, what to do with it?
			switch(i_cvar_mode)
			{
				case 1: engfunc(EngFunc_RemoveEntity,ent) // remove it...
				case 2: set_wz_ent_team(ent,TEAM_NEUTRAL) // change it's team to neutral (so that everybody can pick it up)
			}
		}
	}
}

// Round has ended...
public Logevent_Round_End()
{
	// Are the items only for 1 round? (CVAR)
	if(get_pcvar_num(g_cvar_item_one_round))
	{
		// Yes - loop trough all item WZ entities...
		static ent
		ent = -1
		
		while((ent = engfunc(EngFunc_FindEntityByString, ent,"classname","item_warzzz")) != 0)
		{
			// This is a custom item - don't continue...
			if(is_wz_ent_custom_item(ent)) continue
			
			engfunc(EngFunc_RemoveEntity,ent) // remove this item...
		}
	}
	
	// Get some values...
	static i_players[32],i_num, i,ii
	get_players(i_players,i_num) // get the number of players in the server
	
	// Loop trough all players in the server...
	for(i=0;i<i_num;i++)
	{
		// Store player index in a more convenient variable
		ii = i_players[i]
		
		// Null all "user" variables from the last player with this id (null?)
		// Class is checked on round start!
		g_i_user_remembered_weapon[ii][REM_WEAPON_PRIMARY] = 0
		g_i_user_remembered_weapon[ii][REM_WEAPON_SECONDARY] = 0
		g_i_user_remembered_weapon[ii][REM_WEAPON_PAGE_PRIMARY] = 0
		
		g_b_user_must_change[ii][CHANGE_PRIMARY] = true
		g_b_user_must_change[ii][CHANGE_SECONDARY] = true
	}
	
	// If we can change our class only once per round, then set "Must change" to players' class
	if(get_pcvar_num(g_cvar_class_change_mode) == 0)
	{
		// Loop trough all players in the server...
		for(i=0;i<i_num;i++)
		{
			// Store player index in a more convenient variable
			ii = i_players[i]
			
			// Set "Must change" to current player's class
			g_b_user_must_change[ii][CHANGE_CLASS] = true
		}
	}
}

// An objective has spawned!
public Fm_Spawn_Objectives(ent)
{
	// Isn't a valid ent - don't continue
	if(!pev_valid(ent)) return FMRES_IGNORED
	
	// Get entity's classname
	static sz_classname[32]
	pev(ent,pev_classname,sz_classname,charsmax(sz_classname))
	
	// Loop trough all objective classnames...
	static i
	for(i=0;i<sizeof g_sz_const_objective_names;i++)
	{
		// There is a match (must remove this entity?)
		if(equal(sz_classname,g_sz_const_objective_names[i]))
		{
			// Remove it...
			engfunc(EngFunc_RemoveEntity,ent)
			
			// It is removed, so block it's spawn...
			return FMRES_SUPERCEDE
		}
	}
	
	// End...
	return FMRES_IGNORED
}

// All WZ entities are being loaded... (rings, custom map items)
WZ_Ent_LoadAll()
{
	// Null total rings variable
	g_i_total_rings = 0
	// Null total custom items variable
	g_i_total_items = 0
	
	// WZ Ent spawn points file doesn't exist for this map?
	if(!file_exists(g_sz_ringfile))
	{
		log_amx("%L",LANG_SERVER,"SV_NOTIFY_NOSPAWNS",g_sz_ringfile)
		
		return
	}
	
	// Open the file...
	static h_open
	h_open = fopen(g_sz_ringfile,"rt")
	
	// Can't open it? (no access, etc...)
	if(!h_open)
	{
		log_amx("%L",LANG_SERVER,"SV_NOTIFY_COULDNTREAD",g_sz_ringfile)
		
		return
	}
	
	// Get some values...
	static sz_buffer[32], sz_coords[3][9], sz_team[2],sz_type[2],
	sz_array_package[ARRAY_WZ_ENT_SPAWNS], Float:f_cache_coords[3],i_cache_team,i_cache_type
	
	// Loop trough every line of the file... (is end reached?)
	while(!feof(h_open))
	{
		// Get current line's contents into a string
		fgets(h_open,sz_buffer,charsmax(sz_buffer))
		
		// The line is empty or it is a comment?
		if(!sz_buffer[0] || sz_buffer[0] == ';' || sz_buffer[0] == '/') continue // continue with the next line
		
		// Parse current line's string into smaller ones (to use them separate)
		parse(sz_buffer, sz_coords[0],8, sz_coords[1],8, sz_coords[2],8, sz_team,charsmax(sz_team), sz_type,charsmax(sz_type))
		
		// Get WZ ent spawn origin... (coords)
		f_cache_coords[0] = str_to_float(sz_coords[0])
		f_cache_coords[1] = str_to_float(sz_coords[1])
		f_cache_coords[2] = str_to_float(sz_coords[2])
		
		// Get WZ ent spawn team...
		i_cache_team = str_to_num(sz_team)
		// Get WZ ent spawn type...
		i_cache_type = str_to_num(sz_type) // 0 = ring
		
		// Package the recieved values
		sz_array_package[WZ_ENT_COORDS] = _:f_cache_coords
		sz_array_package[WZ_ENT_TEAM] = i_cache_team
		sz_array_package[WZ_ENT_TYPE] = i_cache_type
		
		// Is the WZ Ent a ring?
		if(!i_cache_type)
		{
			// Yes...
			
			// Add the packaged values to the dynamic array that holds all rings' spawn points data
			ArrayPushArray(g_array_ringspawns,sz_array_package)
			
			// Increase the number of total rings on the map
			g_i_total_rings++
		} else {
			// Else - No, this is an item!
			
			// Add the packaged values to the dynamic array that holds all custom items' spawn points data
			ArrayPushArray(g_array_itemspawns,sz_array_package)
			
			// Increase the number of total custom items on the map
			g_i_total_items++
		}
	}
	
	// All rings have been loaded!
	
	// Close the file (free it)
	fclose(h_open)
}

// Ring is spawned!
Ring_Spawn(array_item)
{
	// Create item's entity (info_target?)
	static ent
	ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString,"info_target"))
	
	if(ent)
	{
		// Get some values...
		static package_array[ARRAY_WZ_ENT_SPAWNS], i_team
		
		ArrayGetArray(g_array_ringspawns,array_item,package_array) // unpack array's data for this ring
		
		i_team = package_array[WZ_ENT_TEAM] // store ring's team in a more convenient variable
		
		// Set classname and model (info?)
		set_pev(ent,pev_classname,"info_ring")
		engfunc(EngFunc_SetModel,ent,"models/warzzz/ring.mdl")
		
		// Set entity solidity and movetype (make it fall)
		set_pev(ent,pev_solid,SOLID_BBOX)
		set_pev(ent,pev_movetype,MOVETYPE_TOSS)
		
		// Set entity solid box size for collision checking
		engfunc(EngFunc_SetSize, ent, Float:{-30.0,-30.0,0.0},Float:{30.0,30.0,5.0})
		
		// Set EARTH gravity
		set_pev(ent,pev_gravity,1.0)
		
		// Set WZ entity values
		set_wz_ent_team(ent,i_team) // team
		set_wz_ent_id(ent,array_item) // id (from the dynamic array)
		
		// If it's not neutral, increase the number of rings for it's team
		if(i_team) g_i_team_data[TEAM_DATA_RINGS][i_team]++
		
		// Set ring origin (at the position, received from the dynamic array)
		engfunc(EngFunc_SetOrigin,ent, package_array[WZ_ENT_COORDS])
	}
}

// All WZ entities must be cleared...
WZ_Ent_ClearAll()
{
	// If there are ring spawns for this map..,
	if(g_i_total_rings)
	{
		// Loop trough all ring entities...
		static ent
		ent = -1
		
		while((ent = engfunc(EngFunc_FindEntityByString, ent,"classname","info_ring")) != 0) engfunc(EngFunc_RemoveEntity,ent) // remove this ring from the map...
	}
	
	// If there are custom item spawns for this map..,
	if(g_i_total_items)
	{
		// Loop trough all custom item entities...
		static ent
		ent = -1
		
		while((ent = engfunc(EngFunc_FindEntityByString, ent,"classname","item_warzzz")) != 0)
		{
			// This is not a custom item - don't continue...
			if(!is_wz_ent_custom_item(ent)) continue
			
			engfunc(EngFunc_RemoveEntity,ent) // remove this custom item from the map...
		}
	}
}

// A new WZ entity spawn point is being created!
WZ_Ent_SaveSpawn(id, Float:v_f_origin[3],i_team, i_type)
{
	// Open ring spawn points file...
	static h_open
	h_open = fopen(g_sz_ringfile,"at")
	
	// Can't open it? (no access, etc...)
	if(!h_open)
	{
		log_amx("%L",LANG_SERVER,"SV_NOTIFY_COULDNTREAD",g_sz_ringfile)
		
		return
	}
	
	// Add a new line to the file (coords, team; type...)
	fprintf(h_open,"%.2f %.2f %.2f %i %i^n",v_f_origin[0],v_f_origin[1],v_f_origin[2], i_team, i_type)
	
	// Display "SUCCESS!" info message...
	console_print(id,"[WARZZZ] %L %L", id,!i_type ? "ADM_NOTIFY_SPAWNADD_RING" : "ADM_NOTIFY_SPAWNADD_ITEM", id,"ADM_NOTIFY_SPAWNADD", v_f_origin[0],v_f_origin[1],v_f_origin[2], g_sz_const_team_names[i_team])
	
	// Close the file (free it)
	fclose(h_open)
	
	// Reload all WZ entities on the map...
	WZ_Ent_LoadAll()
}

// WZ entity natives......
set_wz_ent_team(ent,i_team) // set WZ ent team
{
	set_pev(ent,pev_iuser1,i_team)
	
	// Set entity glow, depending on the specified team
	fm_set_rendering(ent, kRenderFxGlowShell,\
	g_i_const_team_colors[i_team][0],g_i_const_team_colors[i_team][1],g_i_const_team_colors[i_team][2],\
	kRenderNormal, 120)
}

set_wz_ent_id(ent,ent_id) set_pev(ent,pev_iuser2,ent_id) // set WZ ent id (used for rings -> id from the dynamic array)
set_wz_ent_type(ent,i_type) set_pev(ent,pev_iuser3,i_type) // set WZ ent type (used for items -> item type)
set_wz_ent_owner(ent,i_owner) set_pev(ent,pev_iuser4,i_owner) // set WZ ent owner (used for items -> item owner)
set_wz_ent_custom_item(ent) set_pev(ent,pev_euser1,1)

get_wz_ent_team(ent) return pev(ent,pev_iuser1) // get WZ ent team
get_wz_ent_id(ent) return pev(ent,pev_iuser2) // get WZ ent id (used for rings -> id from the dynamic array)
get_wz_ent_type(ent) return pev(ent,pev_iuser3) // get WZ ent type (used for items -> item type)
get_wz_ent_owner(ent) return pev(ent,pev_iuser4) // get WZ ent owner (used for items -> item owner)
bool:is_wz_ent_custom_item(ent) return (pev(ent,pev_euser1) == 1)

// Check if a player is stuck (credits to VEN)
is_player_stuck(id)
{
	static Float:originF[3]
	pev(id, pev_origin, originF)
	
	engfunc(EngFunc_TraceHull, originF, originF, 0, (pev(id, pev_flags) & FL_DUCKING) ? HULL_HEAD : HULL_HUMAN, id, 0)
	
	if (get_tr2(0, TraceResult:TR_StartSolid) || get_tr2(0, TraceResult:TR_AllSolid) || !get_tr2(0, TraceResult:TR_InOpen))
		return true;
	
	return false;
}

// I failed to find a good colorchat with RED/BLUE/GREY colors and ML support, so I used this
// with formatting seperate string variables with formatex for the ML keys...
PrepareColorChat(id,Color:type,const msg[],{Float, Sql, Result,_}:...)
{
	static sz_cache_chat_msg[192]
	
	vformat(sz_cache_chat_msg[1],charsmax(sz_cache_chat_msg), msg,4)
	
	ColorChat(id,type,sz_cache_chat_msg)
}

/*START - From colorchat.inc by Numb */
ColorChat(id, Color:type, message[]) {
	switch(type) {
		case NORMAL: message[0] = 0x01
		case GREEN: message[0] = 0x04
		default: message[0] = 0x03
	}
	
	message[192] = '^0'

	new team, ColorChange, index, MSG_Type

	if(id) {
		MSG_Type = MSG_ONE
		index = id
	} else {
		index = FindPlayer()
		MSG_Type = MSG_ALL
	}

	team = get_user_team(index)
	ColorChange = ColorSelection(index, MSG_Type, type)

	ShowColorMessage(index, MSG_Type, message)

	if(ColorChange)
		Team_Info(index, MSG_Type, TeamName[team])
}

ShowColorMessage(id, type, message[]) {
	static bool:saytext_used
	static get_user_msgid_saytext

	if(!saytext_used) {
		get_user_msgid_saytext = get_user_msgid("SayText")
		saytext_used = true
	}

	message_begin(type, get_user_msgid_saytext, _, id)
	write_byte(id)
	write_string(message)
	message_end()
}

Team_Info(id, type, team[]) {
	static bool:teaminfo_used
	static get_user_msgid_teaminfo

	if(!teaminfo_used) {
		get_user_msgid_teaminfo = get_user_msgid("TeamInfo")
		teaminfo_used = true
	}

	message_begin(type, get_user_msgid_teaminfo, _, id)
	write_byte(id)
	write_string(team)
	message_end()

	return 1
}

ColorSelection(index, type, Color:Type) {
	switch(Type) {
		case RED: return Team_Info(index, type, TeamName[1])
		case BLUE: return Team_Info(index, type, TeamName[2])
		case GREY: return Team_Info(index, type, TeamName[0])
	}

	return 0
}

FindPlayer() {
	static i
	i = -1

	while(i <= get_maxplayers()) {
		if(is_user_connected(++i))
			return i
	}

	return -1
}
/*END - From colorchat.inc by Numb */
